local function grid_for_spec_part(spec, part)
  local grid = {}
  for x, col in pairs(spec) do
    for y, v in pairs(col) do
      if v == 1 then
        grid_store(grid, Vector.new(x - 1, y - 1), part)
      end
    end
  end
  return grid
end
local function interactions_for_part(spec, part)
  return fully_connected_object_interactions(grid_for_spec_part(spec, part))
end

location.std.generators[1].dynamic = function(ct)
  return interactions_for_part(get_spec(ct), 1)
end
location.std.checkers[1].dynamic = function(ct)
  return interactions_for_part(get_spec(ct), 1)
end
location.std.checkers[2].dynamic = function(ct)
  return interactions_for_part(get_spec(ct), 2)
end

local specifications = --Generated in C++ then fiddled with a bit - originally uniformly randomly chosen from set of connected things fitting in an 8x8 box and touching every corner
{
	{
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 0, 0, 1, 1, 1, 1, 0},
		{0, 0, 0, 0, 1, 1, 0, 0},
		{0, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 0, 1, 0, 1, 1, 1},
		{1, 0, 0, 1, 1, 0, 1, 0},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 0, 1, 0, 0, 0, 1, 0}
	},
	{
		{0, 0, 0, 0, 0, 1, 0, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 0, 0, 1, 0, 0, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 0, 1, 0, 0, 0},
		{1, 0, 0, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 0, 0, 1, 0, 1},
		{0, 0, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 0, 1, 1, 0, 1},
		{1, 0, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{0, 0, 1, 1, 0, 0, 1, 1},
		{1, 1, 1, 1, 1, 0, 0, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 0, 0, 1, 1, 0},
		{1, 1, 1, 1, 1, 1, 0, 0},
		{1, 0, 1, 0, 1, 1, 1, 1},
		{1, 0, 0, 0, 1, 1, 0, 1},
		{1, 1, 1, 1, 1, 0, 1, 0},
		{1, 0, 0, 1, 0, 1, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 0, 0, 1, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 1, 0, 0, 1},
		{0, 1, 0, 1, 0, 0, 0, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 0, 1, 0, 1, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 0, 1, 0, 0, 0},
		{1, 1, 1, 1, 1, 0, 1, 1},
		{1, 0, 0, 1, 1, 1, 1, 1},
		{1, 1, 0, 0, 1, 0, 1, 0},
		{1, 0, 0, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 0, 1, 0, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 0, 1, 0, 0, 1},
		{1, 1, 0, 0, 1, 0, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 0, 0, 1, 1},
		{1, 0, 0, 1, 1, 1, 1, 0},
		{0, 0, 0, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 0, 0, 1, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 0, 1, 0, 0, 1},
		{0, 0, 0, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 0, 0, 1, 1, 0, 0, 0},
		{1, 1, 0, 1, 1, 1, 1, 1},
		{1, 1, 0, 0, 1, 1, 0, 1},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 0, 1, 0, 1, 0},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 0, 1, 0, 1, 0, 0, 1},
		{1, 0, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 0, 1, 1, 0, 0},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 0, 1, 0, 1, 1},
		{1, 1, 1, 1, 1, 0, 1, 1},
		{0, 1, 0, 0, 0, 0, 1, 1},
		{1, 1, 0, 0, 0, 1, 1, 1},
		{1, 1, 1, 1, 1, 0, 0, 1},
		{1, 1, 0, 1, 0, 0, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 0, 1, 0, 1, 0},
		{0, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 0, 1, 0, 0, 1},
		{1, 0, 0, 0, 1, 1, 1, 1},
		{1, 1, 1, 1, 1, 0, 0, 0},
		{1, 0, 1, 0, 1, 1, 1, 1},
		{1, 1, 1, 0, 0, 1, 1, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 0, 1, 0, 1, 1},
		{0, 1, 1, 1, 1, 1, 1, 1},
		{0, 0, 0, 1, 0, 1, 0, 0},
		{0, 1, 1, 1, 1, 1, 1, 1},
		{1, 0, 1, 1, 0, 1, 1, 0},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 0, 0, 0, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 0, 1, 1, 0, 0},
		{1, 1, 1, 1, 1, 0, 0, 0},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 1, 0, 1, 0},
		{1, 1, 0, 0, 0, 0, 1, 1},
		{0, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 0, 1, 0, 0, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 0, 1, 1, 0, 1},
		{1, 1, 1, 1, 1, 1, 0, 1},
		{0, 1, 1, 0, 0, 0, 0, 1},
		{1, 1, 1, 0, 0, 0, 1, 1},
		{1, 0, 0, 1, 1, 1, 1, 0},
		{1, 0, 0, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 0, 1, 1, 0, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 0, 0, 1, 1, 1},
		{1, 1, 1, 1, 1, 0, 0, 0},
		{0, 1, 0, 1, 0, 0, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 1, 1, 0, 1, 1, 1, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 0, 1, 1, 1, 0},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 0, 0, 0, 1, 1, 1, 1},
		{1, 0, 0, 0, 0, 1, 0, 1},
		{1, 1, 1, 1, 1, 0, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 1, 0, 1, 0},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 0, 1, 1, 1, 1},
		{1, 1, 1, 1, 1, 0, 1, 1},
		{0, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 0, 0, 0, 1, 1, 1},
		{1, 1, 1, 1, 0, 1, 1, 1},
		{0, 0, 0, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 0, 1, 1, 0},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 0, 0, 0, 0},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{0, 1, 1, 1, 1, 0, 0, 1},
		{0, 0, 1, 0, 1, 1, 0, 0},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 0, 1, 0, 0, 0, 1, 1},
		{1, 1, 1, 0, 1, 1, 1, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 0, 0, 0, 1},
		{1, 1, 1, 1, 0, 1, 1, 1},
		{0, 1, 1, 1, 1, 1, 0, 1},
		{1, 1, 1, 1, 0, 1, 1, 0},
		{0, 1, 0, 0, 1, 1, 1, 1},
		{1, 1, 0, 0, 0, 1, 0, 0},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 0, 0, 0, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 0, 0, 0, 0, 0, 1, 1},
		{0, 0, 1, 1, 1, 0, 0, 1},
		{1, 1, 0, 0, 1, 1, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 1, 1, 0, 1, 1, 1, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 0, 0, 1, 0},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 0, 1, 1, 1},
		{1, 1, 0, 0, 1, 1, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 0, 0, 1, 0, 1, 0, 1},
		{1, 1, 1, 0, 0, 1, 1, 0},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 0, 0, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{0, 0, 1, 1, 1, 1, 0, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{0, 0, 0, 0, 1, 1, 1, 0},
		{1, 1, 1, 1, 0, 1, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 0, 0, 1, 0},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{0, 1, 1, 0, 1, 0, 1, 0},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 1, 0, 1, 1, 1, 1, 1},
		{1, 0, 0, 0, 1, 1, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 0, 0, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{0, 1, 0, 1, 0, 1, 1, 1},
		{1, 1, 1, 0, 0, 0, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 0, 0, 0, 1, 0, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 0, 1, 0, 0},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 1, 0, 0, 1, 1, 1, 1},
		{0, 1, 1, 1, 0, 0, 0, 1},
		{1, 0, 1, 0, 0, 1, 0, 0},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 1, 1, 0, 1, 1, 1, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 0, 1, 0, 1},
		{0, 0, 1, 1, 1, 1, 1, 1},
		{0, 0, 0, 1, 0, 0, 0, 1},
		{0, 0, 0, 1, 1, 1, 1, 1},
		{0, 0, 1, 1, 1, 1, 1, 1},
		{0, 0, 0, 0, 1, 0, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 0, 1, 0, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{0, 0, 1, 1, 1, 0, 1, 0},
		{0, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 0, 1, 0, 0, 1, 0},
		{1, 1, 1, 1, 1, 0, 1, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 0, 1, 1, 0},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{0, 1, 1, 0, 0, 1, 1, 1},
		{1, 1, 0, 0, 0, 0, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 1, 1, 1, 0, 1, 0, 0},
		{1, 1, 1, 0, 1, 1, 1, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 1, 1, 1, 1},
		{1, 1, 0, 0, 0, 0, 1, 1},
		{0, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 1, 1, 0, 1},
		{1, 1, 0, 1, 0, 0, 1, 1},
		{0, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 0, 0, 1, 0, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 0, 1, 0, 0},
		{0, 0, 1, 1, 1, 1, 1, 1},
		{1, 0, 0, 1, 1, 1, 0, 1},
		{1, 1, 1, 1, 1, 0, 0, 0},
		{1, 1, 1, 0, 1, 1, 1, 1},
		{1, 0, 1, 0, 0, 0, 1, 0},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 0, 1, 0, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 0, 0, 1, 0, 1, 1, 1},
		{1, 1, 1, 1, 0, 0, 0, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{0, 1, 0, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 0, 1, 0, 1},
		{0, 1, 1, 1, 1, 1, 1, 1},
		{1, 0, 0, 1, 1, 0, 0, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{0, 1, 1, 0, 0, 1, 0, 0},
		{0, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 0, 1, 1, 0, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 0, 1, 0, 1},
		{0, 0, 0, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 0, 1, 0, 1},
		{1, 1, 0, 0, 0, 1, 0, 0},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{0, 1, 0, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 1, 0, 1, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 0, 1, 1, 0},
		{0, 1, 1, 1, 1, 1, 1, 1},
		{1, 0, 1, 1, 1, 0, 1, 1},
		{1, 0, 0, 0, 1, 0, 0, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 0, 0, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 0, 1, 1, 1},
		{0, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 0, 1, 1, 0, 1, 0},
		{0, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 0, 0, 0, 1, 0, 0},
		{1, 1, 0, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 1, 1, 0, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 1, 0, 0, 0},
		{0, 0, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 0, 0, 1, 0},
		{1, 0, 0, 1, 1, 1, 1, 1},
		{0, 1, 1, 1, 1, 1, 1, 0},
		{1, 1, 1, 0, 0, 1, 0, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 1, 0, 0, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 0, 0, 1, 1, 1, 0, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 1, 1, 0, 1},
		{0, 1, 0, 1, 0, 0, 0, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 1, 0, 0, 1},
		{0, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 0, 0, 1, 1, 0},
		{1, 0, 0, 1, 1, 1, 1, 1},
		{0, 0, 1, 1, 1, 0, 1, 0},
		{1, 1, 1, 0, 0, 0, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 1, 0, 1, 0},
		{1, 1, 1, 1, 0, 0, 1, 1},
		{0, 1, 0, 0, 0, 1, 1, 1},
		{1, 1, 1, 0, 0, 1, 1, 1},
		{1, 1, 0, 0, 1, 1, 0, 1},
		{1, 0, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 1, 0, 1, 0},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 1, 0, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 0, 1, 1, 1, 0, 1, 0},
		{1, 1, 0, 1, 1, 1, 1, 1},
		{1, 1, 1, 0, 0, 1, 1, 1},
		{0, 1, 1, 1, 1, 0, 0, 0},
		{1, 1, 1, 0, 1, 1, 1, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 1, 0, 1, 0},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 0, 1, 1, 1, 1, 0},
		{0, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 0, 1, 1, 1, 1, 1},
		{1, 0, 0, 0, 0, 0, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 1, 0, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 0, 1, 1, 1, 0, 1},
		{0, 1, 1, 1, 0, 1, 1, 1},
		{1, 1, 1, 0, 0, 1, 0, 1},
		{0, 0, 0, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 1, 0, 1, 0},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 1, 1, 0, 0},
		{1, 1, 0, 1, 1, 1, 1, 1},
		{1, 1, 0, 0, 1, 1, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{0, 1, 0, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 0, 0, 1, 1},
		{1, 1, 1, 0, 1, 1, 1, 0},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 1, 1, 0, 1},
		{1, 1, 1, 1, 0, 0, 0, 1},
		{1, 0, 0, 0, 0, 0, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 0, 1, 1, 1, 0, 1, 1},
		{0, 0, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 1, 0, 1, 0},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 1, 1, 0, 1},
		{0, 0, 0, 0, 1, 0, 1, 1},
		{0, 1, 1, 1, 1, 1, 1, 1},
		{1, 0, 1, 0, 1, 1, 1, 0},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 0, 1, 1, 0, 1, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 1, 1, 1, 0},
		{1, 1, 1, 1, 1, 1, 0, 1},
		{0, 0, 0, 0, 1, 0, 0, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 0, 0, 1, 0, 1, 0},
		{1, 1, 0, 0, 0, 1, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 0, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 0, 1, 1, 0},
		{0, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 0, 0, 1, 0},
		{1, 1, 0, 0, 1, 1, 1, 1},
		{0, 0, 0, 0, 0, 0, 1, 0},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 1, 0, 0, 0, 0, 0},
		{1, 1, 1, 1, 1, 0, 0, 0},
		{1, 0, 0, 0, 1, 1, 1, 1},
		{1, 1, 1, 1, 0, 1, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 1, 1, 0, 1, 0, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 1, 0, 0, 0, 0, 1},
		{1, 1, 1, 1, 1, 1, 0, 1},
		{1, 1, 1, 0, 1, 0, 1, 1},
		{1, 1, 1, 1, 1, 1, 0, 0},
		{0, 1, 1, 0, 1, 1, 1, 1},
		{1, 1, 0, 1, 1, 1, 0, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 0, 1, 0, 0, 0, 1, 1}
	},
	{
		{0, 0, 1, 0, 0, 0, 0, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{0, 1, 1, 1, 0, 0, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 0, 0, 0, 0, 1, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 1},
		{1, 1, 1, 1, 1, 1, 1, 0},
		{1, 0, 1, 0, 0, 0, 1, 1}
	}
}
function get_spec(n)
  return specifications[(n % #specifications) + 1]
end
